<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Administrator\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\FormField;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


/**
 * EasystoreWebhookButton field
 *
 * @since   1.0.0
 */
class EasystoreWebhookButtonField extends FormField
{
    /**
     * Field type
     *
     * @var     string  $type
     * @since   1.0.0
     */
    protected $type = 'EasystoreWebhookButton';

    /**
     * Override getInput function form FormField
     *
     * @return  string  Field HTML string
     * @since   1.0.0
     */
    protected function getInput()
    {
        Text::script('PLG_EASYSTORE_STRIPE_WEBHOOK_ENDPOINT_CREATED');

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->registerAndUseScript('com_easystore.custom-field.admin', 'media/com_easystore/js/custom-field.admin.js', [], ['defer' => true]);

        $text        = !empty($this->element['text']) ? $this->element['text'] : 'Button';
        $paymentType = !empty($this->element['pluginType']) ? (string)$this->element['pluginType'] : '';

        $WebhookSecretKey = $this->form->getValue('stripe_webhook_secret_key', 'params');
        $buttonDisable    = !empty($WebhookSecretKey) ? 'disabled="disabled"' : '';


        return '<button id="easystore-create-webhook" data-paymenttype="' . $paymentType . '" class="btn btn-success" ' .  $buttonDisable . ' >' . Text::_($text) . '</button>';
    }
}
