<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Layout\LayoutHelper;
use JoomShaper\Component\EasyStore\Administrator\Helper\EasyStoreHelper;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect')
    ->useStyle('com_easystore.admin');

$app       = Factory::getApplication();
$user      = Factory::getApplication()->getIdentity();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$saveOrder = ($listOrder == 'a.id' && strtolower($listDirn) == 'asc');

if ($saveOrder && !empty($this->items)) {
    $saveOrderingUrl = 'index.php?option=com_easystore&task=customers.saveOrderAjax&' . Session::getFormToken() . '=1';
}

?>
<form action="<?php echo Route::_('index.php?option=com_easystore&view=customers'); ?>" method="post" name="adminForm" id="adminForm">
    <div id="j-main-container" class="j-main-container easystore-container">
        <?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>

        <?php if (empty($this->items)) : ?>
            <div class="alert alert-info">
                <span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <table class="table" id="customerList">
                <caption class="visually-hidden">
                    <?php echo Text::_('COM_EASYSTORE_USERS_TITLE'); ?>,
                    <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
                    <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                </caption>
                <thead>
                    <tr>
                        <td class="w-1 text-center">
                            <?php echo HTMLHelper::_('grid.checkall'); ?>
                        </td>

                        <th scope="col">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_EASYSTORE_USERS_FULL_NAME', 'name', $listDirn, $listOrder); ?>
                        </th>

                        <th scope="col" >
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_EASYSTORE_CUSTOMER_ORDERS', 'orders', $listDirn, $listOrder); ?>
                        </th>
                        <th scope="col">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_EASYSTORE_CUSTOMER_TOTAL_SPENT', 'total_spend', $listDirn, $listOrder); ?>
                        </th>

                        <th scope="col" class="w-5 d-none d-md-table-cell">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tbody <?php if ($saveOrder) : ?> 
                    class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" data-nested="true" <?php
                       endif; ?>>
                    <?php
                    foreach ($this->items as $i => $item) :
                        $canCreate  = $user->authorise('core.create', 'com_easystore');
                        $canEdit    = $user->authorise('core.edit', 'com_easystore');
                        ?>
                        <tr class="row<?php echo $i % 2; ?>" data-item-id="<?php echo $item->id; ?>" sortable-group-id="1" data-draggable-group="1">
                            <td class="text-center">
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $this->escape($item->name)); ?>
                            </td>

                            <th scope="row">
                                <div class="d-flex align-items-center">
                                    <?php if (!empty($item->image)) : ?>
                                        <span class="me-4"><img src="<?php echo $item->image; ?>" alt="<?php echo $this->escape($item->name); ?>" height="80" width="80" class='easystore-customer-image-circle'></span>
                                    <?php else : ?>
                                        <span class="me-4">
                                            <?php EasyStoreHelper::createImagePlaceHolder($item->name, 'easystore-customer-image-placeholder');?>
                                        </span>
                                    <?php endif; ?>
                                    <span class="d-block">
                                      
                                        <?php if ($canEdit) : ?>
                                            <a href="<?php echo Route::_('index.php?option=com_easystore&task=customer.edit&id=' . $item->id); ?>" title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->name); ?>">
                                                <?php echo $this->escape($item->name); ?>
                                            </a>
                                        <?php else : ?>
                                            <?php echo $this->escape($item->name); ?>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </th>

                            <td>
                                <?php echo $this->escape($item->orders); ?>
                            </td>
                            <td>
                                <?php echo $this->escape(EasyStoreHelper::formatCurrency($item->total_spend)); ?>
                            </td>

                            
                            <td class="d-none d-md-table-cell">
                                <?php echo (int) $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <?php echo $this->pagination->getListFooter(); ?>

        <?php endif; ?>

        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
</form>