<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);
$return = Uri::getInstance()->toString();
$loginUrl = Route::_('index.php?option=com_users&view=login&return=' . base64_encode($return), false);
$user = Factory::getApplication()->getIdentity();
$settings = SettingsHelper::getSettings();
$allowGuestCheckout = $settings->get('checkout.allow_guest_checkout', false);
$isGuestCheckout = $user->guest && $allowGuestCheckout;
$logoutUrl = Route::_('index.php?option=com_users&view=login&layout=logout&return=' . base64_encode($return), false);
$isLoggedInUser = !$user->guest;
?>

<div class="easystore-widget easystore-checkout-contact">
    <div class="easystore-contact-header">
        <h3 class="easystore-widget-title mb-0"><?php echo Text::_('COM_EASYSTORE_CHECKOUT_CONTACT_LABEL'); ?></h3>

        <?php if ($isGuestCheckout) : ?>
            <p><?php echo Text::_('COM_EASYSTORE_HAVE_AN_ACCOUNT_TEXT'); ?> <a href="<?php echo $loginUrl; ?>"><?php echo Text::_('JLOGIN'); ?></a></p>
        <?php endif; ?>

        <?php if ($isLoggedInUser) : ?>
            <a href="<?php echo $logoutUrl; ?>"><?php echo Text::_('JLOGOUT'); ?></a>
        <?php endif; ?>
    </div>

    <?php if ($isLoggedInUser) : ?>
        <div>
            <span><?php echo $user->name; ?></span>
            <span>(<?php echo $user->email; ?>)</span>
        </div>
    <?php endif; ?>

    <?php if ($isGuestCheckout) : ?>
        <div class="easystore-contact-with-spinner">
            <input
                name="email"
                type="email"
                class="form-control"
                required
                placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_EMAIL_PLACEHOLDER'); ?>"
                @change="searchGuestUser"
            />
            <span x-show="!!searchLoading" class="easystore-spinner dark small" />
        </div>
    <?php endif; ?>
</div>
