<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);
?>

<div class="easystore-widget easystore-checkout-information" x-cloak>
    <h3 class="easystore-checkout-title easystore-widget-title">
        <?php echo Text::_('COM_EASYSTORE_SHIPPING_METHOD'); ?>
    </h3>
    <ul class="easystore-shipping-methods" x-ref="shippingMethod" x-show="shipping?.length > 0">
        <template x-for="(shippingItem, index) in shipping" :key="index">
            <li :class="{'is-active': (cart.shipping_method?.uuid === shippingItem.uuid)}">
                <label x-id="['shipping-method']" :for="$id('shipping-method')">
                    <input class="form-check-input" type="radio" name="shipping_method" :id="$id('shipping-method')" :value="JSON.stringify(shippingItem)"
                        :checked="(cart.shipping_method?.uuid === shippingItem.uuid) || (index == 0)" required @change="active_shipping = shippingItem.uuid" />
                    <div class="easystore-shipping-method">
                        <div class="easystore-shipping-method-name" x-text="shippingItem.name"></div>
                        <div class="easystore-shipping-method-description" x-text="shippingItem.estimate"></div>
                    </div>
                    <span class="easystore-shipping-price" x-text="shippingItem.rate_with_currency"></span>
                </label>
            </li>
        </template>
    </ul>
    <div class="easystore-no-shipping" x-show="!shipping?.length"><?php echo Text::_('COM_EASYSTORE_CART_NO_SHIPPING_AVAILABLE'); ?></div>
</div>