<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Language\Text;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

$settings         = SettingsHelper::getSettings();
$enableTax        = $settings->get('checkout.enable_tax', true);
$enableCouponCode = $settings->get('checkout.enable_coupon_code', true);

?>

<div x-cloak>
    <div x-show="!!cart?.items" x-transition class="easystore-checkout-items">
        <template x-for="cartItem in cart.items" :key="cartItem.id">
            <div class="easystore-checkout-item">
                <div class="row align-items-center">
                    <div class="col-2">
                        <video class="easystore-checkout-item-thumbnail" x-show="cartItem.isVideo" :src="cartItem.image?.src ?? ''" :alt="cartItem.name" loading="lazy" height="56"></video>
                        <img class="easystore-checkout-item-thumbnail" x-show="!cartItem.isVideo" :src="cartItem.image?.src ?? ''" :alt="cartItem.name" loading="lazy" />
                    </div>

                    <div class="col-7">
                        <h3 class="easystore-h4 mb-2" x-text="cartItem.title"></h3>

                        <div class="easystore-metadata-h">
                            <template x-for="(option, index) in cartItem.options" :key="option.key">
                                <div class="easystore-metadata-item">
                                    <span class="easystore-metadata-key" x-text="option.key + ':'"></span>
                                    <span class="easystore-metadata-value" x-text="option.name"></span>
                                </div>
                            </template>
                            <div class="easystore-metadata-item" x-show="cartItem.discounted_price > 0">
                                <span class="easystore-metadata-key">
                                    <?php echo Text::_('COM_EASYSTORE_CART_PRICE'); ?>
                                </span>
                                <span class="easystore-metadata-value" x-show="cartItem.discounted_price > 0">
                                    <span x-text="cartItem.discounted_price_with_currency"></span>
                                    <del x-text="cartItem.price_with_currency"></del>
                                </span>

                                <span class="easystore-metadata-value" x-show="cartItem.discounted_price <= 0">
                                    <span x-text="cartItem.price_with_currency"></span>
                                </span>
                            </div>

                            <div class="easystore-metadata-item">
                                <span class="easystore-metadata-key">
                                    <?php echo Text::_('COM_EASYSTORE_QUANTITY'); ?>:
                                </span>
                                <span class="easystore-metadata-value" x-text="cartItem.quantity"></span>
                            </div>
                            <div class="easystore-metadata-item" x-show="cartItem.weight > 0">
                                <span class="easystore-metadata-key">
                                    <?php echo Text::_('COM_EASYSTORE_CHECKOUT_SUMMARY_WEIGHT'); ?>:
                                </span>
                                <span class="easystore-metadata-value" x-text="cartItem.weight_with_unit"></span>
                            </div>
                        </div>
                    </div>

                    <div class="col d-flex justify-content-md-end">
                        <span class="easystore-checkout-item-subtotal" x-text="cartItem.total_price_with_currency"></span>
                        <!-- @todo: need each item price -->
                    </div>
                </div>
            </div>
        </template>
    </div>

    <div class="easystore-skeleton-container" x-show="loading">
        <span class="easystore-skeleton"></span>
        <span class="easystore-skeleton"></span>
        <span class="easystore-skeleton"></span>
        <span class="easystore-skeleton"></span>
    </div>

    <div class="easystore-checkout-footer easystore-list-section" x-show="!loading">
        <div class="easystore-list-item">
            <span class="easystore-list-key fw-bold">
                <?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_SUBTOTAL'); ?>
            </span>
            <span class="easystore-list-value fw-bold" x-text="cart.sub_total_with_currency"></span>
        </div>

        <div class="easystore-list-group">
            <?php if ($enableCouponCode) : ?>
                <div class="easystore-list-item" x-show="!cart.coupon_code">
                    <div class="w-100" x-show="!coupon.showCouponInput">
                        <a href="#" @click.prevent="handleAddPromotionClick"><?php echo Text::_('COM_EASYSTORE_CHECKOUT_ADD_PROMOTION_CODE'); ?>
                        </a>
                    </div>
                    <div class="w-100" x-show="coupon.showCouponInput" x-transition>
                        <div class="easystore-checkout-coupon-container">
                            <input x-ref="couponInput" type="text" class="form-control" x-model="coupon.code" @keyup.enter="applyCouponCode" @keydown.enter="$event.preventDefault()"
                                @click.outside="handleCouponInputOutsideClick">
                            <button type="button" class="btn" x-show="coupon.code.length > 0" @click.prevent="applyCouponCode">
                                <?php echo Text::_('COM_EASYSTORE_CHECKOUT_COUPON_APPLY_BUTTON'); ?>
                            </button>
                        </div>
                        <span x-show="coupon.message" x-text="coupon.message"></span>
                    </div>
                </div>
            <?php endif;?>

            <div class="easystore-list-item" x-show="!!cart.coupon_code">
                <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_COUPON_DISCOUNT'); ?></span>
                <div class="easystore-list-value">
                    <span x-text="cart.coupon_code"></span>
                    <button type="button" class="btn" @click="removeCouponCode">x</button>
                </div>
                <span class="easystore-list-value" x-text="`-${cart.coupon_discount_with_currency}`"></span>
            </div>

            <div class="easystore-list-item" x-show="!!cart.shipping_method">
                <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_SHIPPING'); ?></span>
                <span class="easystore-list-value" x-text="`${cart.shipping_method?.name ?? ''}`"></span>
                <span class="easystore-list-value" x-text="`${cart.shipping_method?.rate_with_currency ?? ''}`"></span>
            </div>

            <?php if ($enableTax) : ?>
                <div class="easystore-list-item">
                    <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_TAX'); ?></span>
                    <span class="easystore-list-value" x-text="`${cart.tax_rate}%`"></span>
                    <span class="easystore-list-value" x-text="cart.taxable_amount_with_currency"></span>
                </div>
            <?php endif;?>

        </div>

        <div class="easystore-list-group-footer">
            <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_TOTAL'); ?></span>
            <span class="easystore-list-value" x-text="cart.total_with_currency"></span>
        </div>
    </div>
</div>