<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

extract($displayData);

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->useScript('com_easystore.product.site');
$wa->useStyle('com_easystore.product.site');
?>
<div class="easystore-order-items">
    <?php foreach ($products as $product) : ?>
        <div class="easystore-order-item">
            <div class="row">
                <div class="col-lg-1">
                    <?php if (!empty($product->imageSrc)) :?>
                        <?php
                        $validVideoFormats = array('mp4', 'avi', 'mov', 'mkv', 'flv', 'wmv', 'webm');
                        $fileExtension = pathinfo($product->imageSrc, PATHINFO_EXTENSION);
                        ?>
                        <?php if (in_array($fileExtension, $validVideoFormats)) : ?>
                            <video class="easystore-product-thumbnail" src="<?php echo $product->imageSrc; ?>" alt="<?php echo $this->escape($product->title); ?>"></video>
                        <?php else : ?>
                            <img class="easystore-product-thumbnail"  src="<?php echo $product->imageSrc; ?>" alt="<?php echo $this->escape($product->title); ?>">
                        <?php endif; ?>
                    <?php endif;?>
                </div>

                <div class="col-lg-5">
                    <div class="easystore-order-item-title mb-2">
                        <strong><?php echo $product->title; ?></strong>
                    </div>

                    <div class="easystore-metadata-h">
                        <div class="easystore-metadata-item">
                            <span class="easystore-metadata-value"><?php echo $product->options; ?></span>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2">
                    <div class="easystore-metadata">
                        <div class="easystore-metadata-item">
                            <span class="easystore-metadata-key"><?php echo Text::_('COM_EASYSTORE_ORDER_PRODUCT_PRICE') ?>:</span>
                            <span class="easystore-metadata-value"><?php echo $product->actualPrice; ?></span>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2">
                    <div class="easystore-metadata">
                        <div class="easystore-metadata-item">
                            <span class="easystore-metadata-key"><?php echo Text::_('COM_EASYSTORE_ORDER_PRODUCT_QUANTITY') ?>:</span>
                            <span class="easystore-metadata-value"><?php echo $product->quantity; ?></span>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2">
                    <div class="easystore-metadata">
                        <div class="easystore-metadata-item">
                            <span class="easystore-metadata-key"><?php echo Text::_('COM_EASYSTORE_ORDER_PRODUCT_PRICE_TOTAL') ?>:</span>
                            <span class="easystore-metadata-value"><?php echo $product->priceWithQuantity; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>