<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Language\Text;

extract($displayData);
?>

<div class="easystore-list-group">
    <div class="easystore-list-group-header">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_PRODUCT_PRICE_TOTAL') ?></span>
        <span class="easystore-list-value"><?php echo $item->sub_total_with_currency; ?></span>
    </div>
    <?php if (!empty($item->sale_tax)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_SALES_TAX') ?></span>
        <span class="easystore-list-value"><?php echo $item->sale_tax_with_currency; ?></span>
    </div>
    <?php endif; ?>
    <?php if (!empty($item->sub_total_tax)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_SUB_TOTAL_AFTER_TAX') ?></span>
        <span class="easystore-list-value"><?php echo $item->sub_total_tax_with_currency; ?></span>
    </div>
    <?php endif; ?>
    <?php if (!empty($item->special_discounted_amount)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_SPECIAL_DISCOUNT_TOTAL') ?></span>
        <span class="easystore-list-value">-<?php echo $item->special_discounted_amount_with_currency; ?></span>
    </div>
    <?php endif; ?>
    <?php if (!empty($item->extra_discount_amount)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_EXTRA_DISCOUNT_TOTAL') ?></span>
        <span class="easystore-list-value">-<?php echo $item->extra_discount_amount_with_currency; ?></span>
    </div>
    <?php endif; ?>
    <?php if (!empty($item->coupon_amount)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_COUPON_AMOUNT') ?></span>
        <span class="easystore-list-value">-<?php echo $item->coupon_discount_with_currency; ?></span>
    </div>
    <?php endif; ?>
    <?php if (!empty($item->shipping_cost)) : ?>
    <div class="easystore-list-item">
        <span class="easystore-list-key"><?php echo Text::_('COM_EASYSTORE_ORDER_SHIPPING_COST') ?></span>
        <span class="easystore-list-value"><?php echo $item->shipping_cost_with_currency; ?></span>
    </div>
    <?php endif; ?>

    <div class="easystore-list-item">
        <span class="easystore-list-key"><strong><?php echo Text::_('COM_EASYSTORE_ORDER_TOTAL_PRICE') ?></strong></span>
        <span class="easystore-list-value"><strong><?php echo $item->total_price_with_currency; ?></strong></span>
    </div>
</div>