<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects
extract($displayData);

$is_unpaid         = $item->payment_status === 'unpaid';
$is_paid           = $item->payment_status === 'paid';
$is_manual_payment = $item->payment_method === 'manual_payment' && $item->payment_status === 'unpaid';

$btn_link = $is_unpaid ? 'javascript:void(0);' : Route::_('index.php?option=com_easystore&view=order&layout=invoice&id=' . (int) $item->id, false);
$btn_text = $is_unpaid ? Text::_('COM_EASYSTORE_ORDER_PAY_NOW') : Text::_('COM_EASYSTORE_ORDER_INVOICE');

$click_event = $is_unpaid ? '@click="handlePaynow(' . htmlspecialchars(json_encode($item)) . ')"' : '';
?>

<a href="<?php echo $btn_link; ?>" class="btn btn-outline-primary <?php echo $is_manual_payment || (!$is_paid && !$is_unpaid) ? 'd-none' : '';?>"  <?php echo $click_event; ?>><?php echo $btn_text; ?></a>