<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com> . All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SppagebuilderAddonEasystoreListTitle extends SppagebuilderAddons
{
    public function render()
    {
        $settings = $this->addon->settings;
        $products = $this->addon->easystoreList;
        $index    = $this->addon->listIndex;
        $showLink = $settings->show_link ?? true;

        return EasyStoreHelper::loadLayout(
            'title',
            [
                'item'     => $products[$index],
                'selector' => isset($settings->selector) ? $settings->selector : 'h4',
                'link'     => $showLink,
            ]
        );
    }

    public function css()
    {
        $css = '';

        $addon_id  = '#sppb-addon-' . $this->addon->id;
        $settings  = $this->addon->settings;
        $cssHelper = new CSSHelper($addon_id);

        $css .= $cssHelper->generateStyle('.easystore-product-title, .easystore-product-title a', $settings, [
            'color'     => 'color',
            'alignment' => 'text-align',
        ], false);

        $css .= $cssHelper->typography('.easystore-product-title', $settings, 'typography');

        return $css;
    }
}
