<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\Email;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Layout\LayoutHelper;

/**
 * Email class
 *
 * @since 1.0.0
 */
class Email extends BaseEmail
{
    /**
     * Method to instantiate the send email created object.
     *
     * @param string    $receiver       Receiver email address
     * @param string    $subject        Subject for the email
     * @param string    $layout         Layout file or static html for email body
     * @param array     $displayData    Body data
     *
     * @since 1.0.0
     */
    public function __construct($receiver, $subject, $layout = '', $displayData = [])
    {
        $this->htmlContent = !empty($layout) ? LayoutHelper::render($layout, $displayData, JPATH_ROOT . '/components/com_easystore/layouts') : $layout;

        parent::__construct($receiver, $subject);
    }
}
