<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Site\Traits;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Plugin\PluginHelper;
use JoomShaper\Component\EasyStore\Site\Helper\ArrayHelper;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

trait Checkout
{
    public function getPaymentMethodList()
    {
        $plugins = PluginHelper::getPlugin('easystore');

        $manualPayment = (object) [
            'type'   => "easystore",
            'name'   => "manual_payment",
            'params' => json_encode([
                "title"       => Text::_("COM_EASYSTORE_PAYMENT_METHOD_COD"),
                "instruction" => Text::_("COM_EASYSTORE_PAYMENT_METHOD_COD"),
                ]),
            'id' => null,
        ];

        array_push($plugins, $manualPayment);

        foreach ($plugins as &$plugin) {
            if (!empty($plugin->params) && is_string($plugin->params)) {
                $params              = json_decode($plugin->params);
                $plugin->title       = $params->title ?? $plugin->name;
                $plugin->instruction = $params->instruction ?? '';
            }

            $plugin->logo = $this->getPaymentLogo($plugin->name);

            unset($plugin->params);
        }

        return $plugins;
    }


    public function getActivePayments()
    {
        $settings = SettingsHelper::getSettings();
        $payments = $settings->get('payment', []);

        if (empty($payments->list)) {
            return [];
        }

        $payments = ArrayHelper::filter(function ($item) {
            return $item->enabled ?? false;
        }, $payments->list);

        return $payments;
    }

    private function getPaymentLogo($name)
    {
        if ($name === 'manual_payment') {
            return Path::clean(Uri::root(true) . '/media/com_easystore/images/cod_logo.svg');
        }

        $paymentPluginPath = JPATH_ROOT . '/plugins/easystore';
        $paymentPluginUri  = Uri::root(true) . '/plugins/easystore';
        $logoPath          = $paymentPluginPath . '/' . $name . '/assets/images/logo.svg';
        $logoUrl           = Path::clean($paymentPluginUri . '/' . $name . '/assets/images/logo.svg');

        if (file_exists($logoPath)) {
            return $logoUrl;
        }

        return '';
    }

    /**
     * Retrieves an array of payment methods that do not require a checkout URL.
     *
     * @return array An array of payment method names.
     * @since 1.0.2
     */

    private function getPaymentMethodsWithoutCheckoutUrl()
    {
        return ['razorpay'];
    }
}
