<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\View\Order;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * View for the user identity validation form
 */
class HtmlView extends BaseHtmlView
{
    /**
    * The active item
    *
    * @var    object
    * @since  1.0.0
    */
    protected $item;
    /**
     * The pagination object
     *
     * @var    \Joomla\CMS\Pagination\Pagination
     *
     * @since  1.0.0
     */
    protected $pagination;

    /**
     * Display the view
     *
     * @param   string  $template  The name of the layout file to parse.
     * @return  void
     */
    public function display($template = null)
    {
        // Get some data from the models
        $this->item = $this->get('Item');

        if (count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $app  = Factory::getApplication();
        $user = $this->getCurrentUser();

        if ($this->item->is_guest_order == 0 && !$user->id) {
            $app->redirect(Route::_('index.php?option=com_users&view=login', false));
        }

        // View also takes responsibility for checking if the user logged in with remember me.
        $cookieLogin = $user->get('cookieLogin');

        if (!empty($cookieLogin)) {
            // If so, the user must login to edit the password and other data.
            // What should happen here? Should we force a logout which destroys the cookies?
            $app = Factory::getApplication();
            $app->enqueueMessage(Text::_('JGLOBAL_REMEMBER_MUST_LOGIN'), 'message');
            $app->redirect(Route::_('index.php?option=com_users&view=login', false));

            return false;
        }

        parent::display($template);
    }
}
