<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\View\Payment;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use JoomShaper\Component\EasyStore\Site\Traits\Token;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;
use JoomShaper\Component\EasyStore\Administrator\Helper\EasyStoreDatabaseOrm;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * View for the user identity validation form
 */
class HtmlView extends BaseHtmlView
{
    use Token;

    /**
     * Display the view
     *
     * @param   string  $template  The name of the layout file to parse.
     * @return  void
     */
    public function display($template = null)
    {
        /** @var CMSApplication */
        $app            = Factory::getApplication();
        $input          = $app->getInput();
        $view           = $input->get('layout', '', 'STRING');
        $settings       = SettingsHelper::getSettings();

        $this->continue_shopping_url = Route::_($settings->get('products.shopPage', 'index.php'), false);
        $this->order_history_url     = Route::_('index.php?option=com_easystore&view=orders', false);
        $this->is_guest_user         = $app->getIdentity()->guest;

        if ($view === 'success') {
            $this->_layout = 'success';
            $paymentType   = $input->getString('type');

            if ($paymentType === 'paypal') {
                $orderID = $input->getString('order_id');
                $order   = (object)['payment_status' => 'pending','id' => $orderID];
                (new EasyStoreDatabaseOrm())->update('#__easystore_orders', $order, 'id');
            }
        }

        if ($view === 'cancel') {
            $orderID             = $input->get('order_id', '', 'STRING');
            $this->order_details = Route::_('index.php?option=com_easystore&view=order&id=' . $orderID, false);
            $this->_layout       = 'cancel';
        }

        parent::display($template);
    }
}
