window.addEventListener('DOMContentLoaded', () => new EasystoreVariants().run());

class EasystoreVariants {
    constructor() {
        this.variants = Joomla.getOptions('easystore.variants') ?? [];
        this.options = Joomla.getOptions('easystore.options') ?? [];
    }

    generateCombination(...options) {
        options.sort();

        return options.join(';');
    }

    findByCombination(combination) {
        return this.variants.find(variant => variant.combination.toLowerCase() === combination) ?? {};
    }

    listenChanges() {
        const priceElement = document.querySelector('.easystore-product-price-current');
        const optionElements = document.querySelectorAll('.easystore-product-variant input[type=radio]:checked');
        const galleryImagesButton = document.querySelectorAll('.easystore-gallery-image');

        const checkedOptions = [...optionElements].reduce((result, currentElement) => {
            const name = currentElement.name;
            const value = currentElement.value;
            result[name] = value;

            return result;
        }, {});

        const variantIdentifier =
            Object.values(checkedOptions).length > 0 ? this.generateCombination(...Object.values(checkedOptions)) : '';
        const selectedVariant = this.findByCombination(variantIdentifier);

        if (!!priceElement && !!selectedVariant) {
            priceElement.innerText = selectedVariant.price_with_currency;
        }

        if (!!galleryImagesButton && selectedVariant) {
            const element = [...galleryImagesButton].find(element => {
                const { dataset } = element;
                return dataset && selectedVariant?.image?.id && dataset.id == selectedVariant.image.id;
            });

            if (!!element) {
                const clickEvent = new Event('click');
                element.dispatchEvent(clickEvent);
            }
        }
    }

    run() {
        this.listenChanges(null);

        const optionElements = document.querySelectorAll('.easystore-product-variant input[type=radio]');

        for (const radioElement of [...optionElements]) {
            radioElement.addEventListener('change', this.listenChanges.bind(this));
        }
    }
}
