<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Paddle
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Paddle\Utils;

use Joomla\CMS\Http\HttpFactory;
use JoomShaper\Plugin\EasyStore\Paddle\Utils\PaddleConstants;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects



class PaddleApi 
{
    /**
     * Gets the payment link for the specified order.
     *
     * @param  object   $orderInfo  The order information.
     * @param  int      $orderID    order ID
     * @return string The payment link URL, or false if the request failed.
     * @since  1.0.0
     */
    public static function getPaymentLink($orderInfo, $orderID) {

        $paddleConstants = new PaddleConstants();

        if (!empty($orderInfo) && $orderID) {
            
            $subTotalPrice = array_reduce((array)$orderInfo->items, function ($carry, $orderInfo) {
                
                $price = $orderInfo->discounted_price ? $orderInfo->discounted_price : $orderInfo->regular_price;
                
                return $carry + ((float)$price * $orderInfo->quantity);
            }, 0);

            $totalPrice  = (float)($subTotalPrice  + $orderInfo->tax + $orderInfo->shipping_charge) - (float)$orderInfo->coupon_discount_amount;

            $requestBody['vendor_id']         = $paddleConstants->getVendorID();
            $requestBody['vendor_auth_code']  = $paddleConstants->getVendorAuthKey();
            $requestBody['webhook_url']       = $paddleConstants->getWebHookUrl();
            $requestBody['return_url']        = $paddleConstants->getReturnUrl($orderID);
            $requestBody['quantity_variable'] = 0;
            $requestBody['passthrough']       = json_encode(['orderID' => $orderID]);
            $requestBody['prices']            = [strtoupper($orderInfo->currency) . ':' . $totalPrice];
            $requestBody['title']             = 'EasyStore';
            $requestBody['discountable']      = 0;

            $url     = $paddleConstants->getPaymentLinkPostUrl();     
            $headers = ['Content-Type: application/x-www-form-urlencoded'];
            
            $response     = HttpFactory::getHttp()->post($url,$requestBody,$headers,30);            
            $responseData = json_decode((string)$response->getBody(),true);

            // If response is true then return the url
            if ($responseData['success']) {
                return $responseData['response']['url'];
            }
        }
        
        return false;
    }
}