<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Paddle
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Paddle\Utils;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


/**
 * Class that contains constants for the Paddle payment gateway.
 * @since 1.0.0
*/
class PaddleConstants 
{
    public $plugin;
    public $pluginParams;
    const SANDBOX_API              = 'https://sandbox-api.paddle.com/';
    const PRODUCTION_API           = 'https://api.paddle.com/';
    const PAYMENT_LINK_PRODUCTION  = 'https://vendors.paddle.com/api/2.0/product/generate_pay_link';
    const PAYMENT_LINK_SANDBOX     = 'https://sandbox-vendors.paddle.com/api/2.0/product/generate_pay_link';
    const PADDLE_JS                = 'https://cdn.paddle.com/paddle/paddle.js';

    public function __construct() {
        $this->plugin       = PluginHelper::getPlugin('easystore', 'paddle');
        $this->pluginParams = new Registry($this->plugin->params);
    }

    public function getPaymentLinkPostUrl() 
    {
        return ($this->pluginParams->get('shop_environment') === 'sandbox') ? self::PAYMENT_LINK_SANDBOX : self::PAYMENT_LINK_PRODUCTION;
    }

    public function getVendorID()
    {
        return $this->pluginParams->get('vendor_id', '');
    }

    public function getVendorAuthKey()
    {
        return $this->pluginParams->get('vendor_auth_key', '');
    }

    public function getWebHookUrl()
    {
        return Route::_(Uri::base() . 'index.php?option=com_easystore&task=payment.onPaymentNotify&type=paddle');
    }

    public function getReturnUrl($orderID) 
    {
        return Route::_(Uri::base() . 'index.php?option=com_easystore&task=payment.onPaymentSuccess');
    }
    public function getPublicKey() {
        return $this->pluginParams->get('paddle_secret_key', '');
    }

    public function getCancelUrl() 
    {
        return Route::_(Uri::base() . 'index.php?option=com_easystore&task=payment.onPaymentCancel');
    }

    public function getEnvironment()
    {
        return $this->pluginParams->get('shop_environment');
    }
} 