<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Paddle
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Factory;
use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;
use JoomShaper\Plugin\EasyStore\Paddle\Utils\PaddleConstants;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);

$paddleConstant = new PaddleConstants();
$environment    = $paddleConstant->getEnvironment();

$inlineJS = <<<JS
    document.addEventListener('DOMContentLoaded' , () => {
        
        const env = `{$environment}`;

        if (env === 'sandbox') {
            Paddle.Environment.set("sandbox");
        }
        
        Paddle.Setup({
            vendor: {$sellerID},          
        });
    })
JS;

$wa = EasyStoreHelper::wa();

// Add script to the document head.
$wa->registerAndUseScript('paddle', PaddleConstants::PADDLE_JS,[], ['type' => 'text/javascript']);
$wa->addInlineScript($inlineJS); 
?>

