<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Paypal
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Paypal\Utils;

use Joomla\Registry\Registry;
use JoomShaper\Component\EasyStore\Administrator\Plugin\Constants;


// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


/**
 * Class that contains constants for the Paypal payment gateway.
 * @since 1.0.0
*/
class PaypalConstants extends Constants
{
    /**
     * Plugin parameters
     *
     * @var Registry
     */
    protected $params;

    /**
     * The payment plugin name
     *
     * @var string
     */
    protected $name = 'paypal';
    
    const SANDBOX_URL    = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
    const PRODUCTION_URL = 'https://www.paypal.com/cgi-bin/webscr';
    

    public function __construct() {
        parent::__construct($this->name);
    }

    /**
     * Get the Paypal URL based on the environment.
     *
     * @return string
     * @since  1.0.0
     */
    public function getPaypalUrl(){
        return (self::getPaymentEnvironment() === 'sandbox') ? self::SANDBOX_URL : self::PRODUCTION_URL;
    }

    /**
     * Get the Paypal merchant email.
     *
     * @return string
     * @since  1.0.0
     */
    public function getMerchantEmail() {
        return (self::getPaymentEnvironment() === 'sandbox') ? self::getTestMerchantEmail() : self::getLiveMerchantEmail();
    }

    /**
     * Get Payment Environment.
     *
     * @return string
     * @since  1.0.5
     */

    public function getPaymentEnvironment()
    {
        return $this->params->get('shop_environment', 'sandbox');
    }


    /**
     * Get Test Merchant Email.
     *
     * @return string
     * @since  1.0.5
     */

    public function getTestMerchantEmail() {
        return $this->params->get('paypal_id');
    }


    /**
     * Get Live Merchant Email.
     * 
     * @return string
     * @since  1.0.5
     */

    public function getLiveMerchantEmail() {
        return $this->params->get('live_paypal_id');
    }
} 